/**
 * \file: mspin_lm_adapter_internal.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin LayerManager Adapter Internal Types
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel BSOT/PJ-ES thilobjoern.fickel@bosch-softtec.com
 *
 * \copyright: (c) 2015 Bosch SoftTec
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/
#ifndef MSPIN_LM_ADAPTER_INTERNAL_H_
#define MSPIN_LM_ADAPTER_INTERNAL_H_

#include <mspin_lm_adapter.h>
#include "mspin_lm_framebuffer_adapter.h"

#include "mySPIN-Core.h" //some typedefs are used
#include <ilm/ilm_client.h>
#include <compositor-shim.h>
#include <semaphore.h>

#ifndef ARRAY_LENGTH
#define ARRAY_LENGTH(a) (sizeof (a) / sizeof (a)[0])
#endif

#define MSPIN_WL_MAX_TOUCHPOINTS 2

#define MSPIN_LM_MINIMUM_TOUCH_INTERVAL_IN_MS 10
#define MSPIN_LM_MINIMUM_POINTER_INTERVAL_IN_MS MSPIN_LM_MINIMUM_TOUCH_INTERVAL_IN_MS

#define MSPIN_MAX_TOUCH_MOVE_DISTANCE_IGNORED 0
#define MSPIN_MAX_POINTER_MOVE_DISTANCE_IGNORED MSPIN_MAX_TOUCH_MOVE_DISTANCE_IGNORED

#define MSPIN_LM_FAIL 0
#define MSPIN_LM_SUCCESS 1

struct mspin_wl_touch_info
{
    bool valid;
    U32 lastTimeAt; //last time index when a touch event was sent
};

typedef struct mspin_wl_touch_info mspin_wl_touch_info;

struct mspin_wl_context
{
    /* Note: Access to this structure must be protected since the WL context might be deleted in parallel. */
    bool initialized;

    enum mspin_lm_flags flags;
    TouchEvent touchEv[MSPIN_WL_MAX_TOUCHPOINTS];
    mspin_wl_touch_info touchInfo[MSPIN_WL_MAX_TOUCHPOINTS];
    U32 lasttimeup1;
    int lastPointerX;
    int lastPointerY;
    int lastSentPointerX;
    int lastSentPointerY;
    uint lastTimePointerEventSent;

    U32 pointerButtonState;
    bool pointerButtonDownToBeSent;

    t_ilm_int screen_x_offset;
    t_ilm_int screen_y_offset;
    t_ilm_int screen_width;
    t_ilm_int screen_height;
    t_ilm_bool force_fullscreen;

    t_ilm_int stride;

    unsigned char* p_image[4];
    bool pollingActive; // set whenever mspin_lm_pumpEvents() is doing poll()

    /* APX internals */
    mspin_framebuffer_context* pFramebufferContext;
    apxPixelFormat surface_format;
    struct compositor_shim_surface_context adapterSurfaceContext;

    /* Wayland internals */
    struct wl_list seats;
    struct wl_display* p_wl_display;
    struct wl_surface* p_wl_surface;
    struct wl_compositor* p_wl_compositor;
    struct serverinfo* p_wl_ext_serverinfo;
    unsigned int wl_connect_id;
    struct wl_registry* p_wl_registry;
    struct wl_event_queue *p_wl_input_queue;
    mspin_layerManager_context_t *p_lm_context;
    pthread_mutex_t lock_seat;
};

struct WlSeat
{
    char*                      p_seat_name;
    uint32_t                   seat_id;
    struct wl_seat*            p_wl_seat;
    struct wl_touch*           p_wl_touch;
    struct wl_pointer*         p_wl_pointer;
    struct mspin_wl_context*   p_wl_context;
    struct wl_list             link;
};

typedef struct WlSeat WlSeat;

#endif /* MSPIN_LM_ADAPTER_INTERNAL_H_ */
